import java.awt.*;
import java.util.*;
import javax.swing.*;
import java.awt.event.*;


	
public abstract class ChangeListener implements ActionListener, ItemListener, FocusListener
{
	private TreeMap<String,Object> oldState = new TreeMap<String,Object>();
	
	
	public ChangeListener() {}
	
	
	public void addTo(Object o) {
		if(o instanceof JTextField) {
			final JTextField f = (JTextField)o;
			f.addFocusListener(this);
			f.addActionListener(this);
		} else if(o instanceof JComboBox) {
			final JComboBox f = (JComboBox)o;
			f.addItemListener(this);
		} else if(o instanceof JCheckBox) {
			final JCheckBox f = (JCheckBox)o;
			f.addItemListener(this);
		}
	}
	
	public void focusGained(FocusEvent e) {
		if(e.getSource() instanceof JTextField) {
			final JTextField f = (JTextField)e.getSource();
			oldState.put(f.toString(), f.getText());
		}
	}
	
	public void focusLost(FocusEvent e) {
		checkChange(e);
	}
	
	public void actionPerformed(ActionEvent e) {
		checkChange(e);
	}
	
	public void itemStateChanged(ItemEvent e) {
		changed(e);
	}
	
	public abstract void changed(EventObject e);
	
	
	
	private void checkChange(EventObject e) {
		if(e.getSource() instanceof JTextField) {
			final JTextField f = (JTextField)e.getSource();
			Object prev = oldState.get(f.toString());
			
			if( prev != null && !f.getText().equals(prev) ) {
				changed(e);	//has actually changed, so notify
			}
			
			//after changed, remove (changed may ask for this value)
			oldState.remove(f.toString());
		}
	}
	
	/**
	 * During the changed method the old state should still be recorded here.
	 * Note that not all types of component record old state.  This is mainly
	 * just for JTextField.
	 */
	protected Object getOldState(Object o) {
		return oldState.get(o.toString());
	}
	
}