import java.awt.*;
import java.util.*;
import javax.swing.*;
import java.awt.event.*;


public class DisplayPanel extends JPanel
{
	//Settings
	private Color color = Color.green;
	private boolean fill = true;
	private boolean drawBorder = true;
	private int nodeRadius = 5;
	private int auxinRadius = 5;
	private boolean render = false;
	//Instance vars
	private Bounds b = new Bounds();
	private Nodes nodes = null;
	private Auxin auxin = new Auxin(auxinRadius);
	private Observer obs = null;
	
	
	public DisplayPanel() {
		setBackground(Color.black);
		setOpaque(true);
		b.fill = fill;
		b.border = drawBorder;
		
		addMouseListener(new MouseListener() {
			public void mousePressed(MouseEvent me) {
				
			}
			
			public void mouseReleased(MouseEvent me) {
				if( !b.isFilled() ) {
					b.rasterize();
					repaint();
					if( obs != null )
						obs.update(null, null);
				} else if( nodes == null ) {
					nodes = new Nodes(me.getPoint(), nodeRadius);
					if( obs != null )
						obs.update(null, null);
					repaint();
				}
			}
			
			public void mouseClicked(MouseEvent me) {
				
			}
			
			public void mouseExited(MouseEvent me) {
				
			}
			
			public void mouseEntered(MouseEvent me) {
				
			}		
		});
		addMouseMotionListener(new MouseMotionListener() {
			public void mouseMoved(MouseEvent me) {
				
			}
			
			public void mouseDragged(MouseEvent me) {
				if( !b.isFilled() ) {
					b.addPoint(me.getPoint());
					repaint();
				}
			}
		});
	}
	
	public void setColor(Color c)			{ color = c; }
	public void setFill(boolean f)			{ fill = f; b.fill = fill; }
	public void setDrawBorder(boolean v)	{ drawBorder = v; b.border = drawBorder; }
	public void setNodeRadius(int r)		{ nodeRadius = r; if(nodes != null) nodes.radius = r; }
	public void setAuxinRadius(int r)		{ auxinRadius = r; if(auxin != null) auxin.radius = r; }
	public void setRender(boolean v)		{ render = v; if(render) nodes.calcThickness(); }
	
	public Color getColor()					{ return color; }
	public boolean getFill()				{ return fill; }
	public boolean getDrawBorder()			{ return drawBorder; }
	public int getNodeRadius()				{ return nodeRadius; }
	public int getAuxinRadius()				{ return auxinRadius; }
	public Bounds getBoundary()				{ return b.isFilled()? b : null; }
	public Nodes getNodes()					{ return nodes; }
	public Auxin getAuxin()					{ return auxin; }
	public boolean getRender()				{ return render; }
	
	public void clear() {
		render = false;
		b = new Bounds();
		b.fill = fill;
		b.border = drawBorder;
		nodes = null;
		auxin = new Auxin(auxinRadius);
		repaint();
	}
	
	
	public void addObserver(Observer o) {
		this.obs = o;
	}
	
	
	/**
	 * Just overriding the component part (border and children will still be handled)
	 */
	public void paintComponent(Graphics g1d) {
		super.paintComponent(g1d);	//paints the background
		Graphics2D g = (Graphics2D)g1d;
		g.setColor(color);
		
		b.paint(g);
		
		if( nodes != null ) {
			if( render ) {
				nodes.paintVeins(g);
			} else {
				g.setColor(Color.red);
				nodes.paint(g);
			}
		}
		
		if( !render && auxin != null ) {
			g.setColor(Color.yellow);
			auxin.paint(g);
		}
	}
	
}
