import java.awt.*;
import java.util.*;
import javax.swing.*;
import java.awt.event.*;


public class Driver extends JFrame
{
	//Constants
	final Color[] colorList = new Color[] {
		Color.red,
		Color.green,
		Color.blue,
		Color.cyan,
		Color.magenta,
		Color.yellow,
		Color.white,
		new Color(139, 69, 19),
		new Color(160, 82, 45),
		new Color(205, 133, 63),
	};
	final String[] colorNames = new String[] {
		"Red",
		"Green",
		"Blue",
		"Cyan",
		"Magenta",
		"Yellow",
		"White",
		"Saddle Brown",
		"Sienna Brown",
		"Peru Brown"
	};
	
	//Instance vars (for GUI)
	private JTextField growF = new JTextField();
	private JTextField nodeF = new JTextField();
	private JTextField diskF = new JTextField();
	private JTextField initPtsF = new JTextField();
	private JTextField addPtsF = new JTextField();
	private JComboBox colorC = new JComboBox(colorNames);
	private JCheckBox fillCB = new JCheckBox("Fill", true);
	private JCheckBox borderCB = new JCheckBox("Border", true);
	private JButton resetB = new JButton("Clear");
	private JButton stepB = new JButton("Step");
	private JButton renderB = new JButton("Render");
	//Computing, etc.
	private DisplayPanel displayP = new DisplayPanel();
	private RunionAlg runion = new RunionAlg();
	
	
	public static void main(String[] args) {
		Driver d = new Driver();
		d.setVisible(true);
		d.pack();
		d.resetGUI();	//make sure GUI is showing inital values
	}
	
	
	public Driver() {
		super("Runion Venetion Alg");
		setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
		final Container c = getContentPane();
		
		//Display
		displayP.setPreferredSize(new Dimension(500,500));
		c.add("Center", displayP);
		
		//Controls
		JPanel optP = new JPanel();
		optP.setLayout(new BoxLayout(optP, BoxLayout.Y_AXIS));
		
		growF.setAlignmentX(Component.LEFT_ALIGNMENT);
		nodeF.setAlignmentX(Component.LEFT_ALIGNMENT);
		initPtsF.setAlignmentX(Component.LEFT_ALIGNMENT);
		addPtsF.setAlignmentX(Component.LEFT_ALIGNMENT);
		colorC.setAlignmentX(Component.LEFT_ALIGNMENT);
		diskF.setAlignmentX(Component.LEFT_ALIGNMENT);
		fillCB.setAlignmentX(Component.LEFT_ALIGNMENT);
		borderCB.setAlignmentX(Component.LEFT_ALIGNMENT);
		
		optP.add( new JLabel("Initial Auxin Sources:", SwingConstants.LEFT));
		optP.add(initPtsF);
		optP.add(new JLabel("Add. Auxin Per Step:", SwingConstants.LEFT));
		optP.add(addPtsF);
		optP.add(new JLabel("Growth Factor:", SwingConstants.LEFT));
		optP.add(growF);
		optP.add(new JLabel("Node Radius:", SwingConstants.LEFT));
		optP.add(nodeF);
		optP.add(new JLabel("Auxin Spread Radius:", SwingConstants.LEFT));
		optP.add(diskF);
		optP.add(new JLabel("Color:", SwingConstants.LEFT));
		optP.add(colorC);
		optP.add(fillCB);
		optP.add(borderCB);
		
		JPanel bp = new JPanel();
		bp.setAlignmentX(Component.LEFT_ALIGNMENT);
		bp.add(resetB);
		bp.add(stepB);
		bp.add(renderB);
		optP.add(bp);
		
		JPanel p1 = new JPanel();
		p1.add(optP);
		c.add("East", p1);
		
		displayP.addObserver(new Observer() {
			public void update(Observable o, Object arg) {
				//When the display panel's mouse controls do something, update our state
				resetGUI();
			}
		});
		
		ChangeListener cl = new ChangeListener() {
			public void changed(EventObject e) {
				updateFromGUI();
			}
		};
		cl.addTo(growF);
		cl.addTo(nodeF);
		cl.addTo(diskF);
		cl.addTo(initPtsF);
		cl.addTo(addPtsF);
		cl.addTo(colorC);
		cl.addTo(fillCB);
		cl.addTo(borderCB);
		
		
		resetB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ae) {
				displayP.clear();
				resetGUI();
			}
		});
		stepB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ae) {
				step();
			}
		});
		renderB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ae) {
				render();
			}
		});
	}
	
	public void resetGUI() {
		colorC.setSelectedIndex( itemsIndexIn(displayP.getColor(), colorList) );
		fillCB.setSelected( displayP.getFill() );
		borderCB.setSelected( displayP.getDrawBorder() );
		nodeF.setText("" + displayP.getNodeRadius());
		diskF.setText("" + displayP.getAuxinRadius());
		growF.setText("" + runion.getGrowFactor());
		initPtsF.setText("" + runion.getInitialAuxin());
		addPtsF.setText("" + runion.getAddAuxin());
		
		if( displayP.getBoundary() != null ) {
			resetB.setEnabled(true);
			if( displayP.getNodes() != null ) {
				stepB.setEnabled(true);
				if( displayP.getRender() )
					renderB.setEnabled(false);
				else
					renderB.setEnabled(true);
			} else {
				stepB.setEnabled(false);
				renderB.setEnabled(false);
			}
		} else {
			resetB.setEnabled(false);
			stepB.setEnabled(false);
			renderB.setEnabled(false);
		}
	}
	
	public void updateFromGUI() {
		displayP.setColor( colorList[colorC.getSelectedIndex()] );
		displayP.setFill( fillCB.isSelected() );
		displayP.setDrawBorder( borderCB.isSelected() );
		
		int nr = 5;
		try{
			nr = Integer.parseInt(nodeF.getText());
		} catch(NumberFormatException nfe) {}
		displayP.setNodeRadius(nr);
		nodeF.setText("" + nr);
		
		int ar = 5;
		try{
			ar = Integer.parseInt(diskF.getText());
		} catch(NumberFormatException nfe) {}
		displayP.setAuxinRadius(ar);
		diskF.setText("" + ar);
		
		double scale = 1;
		try{
			scale = Double.parseDouble(growF.getText());
		} catch(NumberFormatException nfe) {}
		runion.setGrowFactor(scale);
		growF.setText("" + scale);
		
		int ip = 10;
		try{
			ip = Integer.parseInt(initPtsF.getText());
		} catch(NumberFormatException nfe) {}
		runion.setInitialAuxin(ip);
		initPtsF.setText("" + ip);
		
		int ap = 5;
		try{
			ap = Integer.parseInt(addPtsF.getText());
		} catch(NumberFormatException nfe) {}
		runion.setAddAuxin(ap);
		addPtsF.setText("" + ap);
		
		displayP.repaint();
	}
	
	/**
	 * Progess the simulation by one step and update display.
	 * (May have been in render mode before, in which case we
	 * hide the rendered veins and continue simulation.)
	 */
	public void step() {
		displayP.setRender(false);
		renderB.setEnabled(true);
		runion.stepSimulation(displayP.getBoundary(), displayP.getNodes(), displayP.getAuxin());
		displayP.repaint();
	}
	
	/**
	 * Hides nodes and auxin, draws the vein lines, and shows them.
	 */
	public void render() {
		renderB.setEnabled(false);
		displayP.setRender(true);
		displayP.repaint();
	}
	
	private int itemsIndexIn(Object item, Object[] list) {
		for(int i = 0; i < list.length; i++) {
			if( list[i].equals(item) )
				return i;
		}
		return -1;
	}
	
}
