import java.awt.*;
import java.util.*;
import java.awt.geom.Point2D;

	
public class RunionAlg
{
	private int initPts = 10;
	private int addPts = 5;
	private double growFactor = 1.0;
	
	
	public RunionAlg() {
		
	}
	
	public void setInitialAuxin(int v)		{ initPts = v; }
	public void setAddAuxin(int v)			{ addPts = v; }
	public void setGrowFactor(double v)		{ growFactor = v; }
	
	public int getInitialAuxin()			{ return initPts; }
	public int getAddAuxin()				{ return addPts; }
	public double getGrowFactor()			{ return growFactor; }
	
	/**
	 * Given a simulation state and the current parameters, take one step
	 */
	public void stepSimulation(Bounds bounds, Nodes nodes, Auxin auxin) {
		if( auxin.size() == 0 ) {
			//Need to initialize
			addAuxin(bounds, nodes, auxin, initPts);
		} else {
			
			//Associate auxin sources with closes node
			class AuxSource
			{
				public Point2D.Double src;
				public AuxSource next = null;
				public AuxSource(Point2D.Double s) { src = s; }
				public AuxSource(Point2D.Double s, AuxSource next) { src = s; this.next = next; }
			}
			class NodeAuxin
			{
				public Nodes.Node node;
				public AuxSource sources = null;
				public NodeAuxin(Nodes.Node n) { node = n; }
				public void addSource(Point2D.Double p) {
					sources = new AuxSource(p, sources);
				}
			}
			ArrayList<NodeAuxin> partition = new ArrayList<NodeAuxin>();
			for(Nodes.Node n : nodes) {
				partition.add(new NodeAuxin(n));
			}
			
			for(Point src : auxin) {
				double shortest = 9999;
				NodeAuxin closest = null;
				double sdx = 0, sdy = 0;
				
				for(NodeAuxin n : partition) {
					final double dx = n.node.p.x - src.x;
					final double dy = n.node.p.y - src.y;
					final double d = dx*dx + dy*dy;
					
					if( d < shortest ) {
						shortest = d;
						closest = n;
						sdx = dx;
						sdy = dy;
					}
				}
				
				if( closest != null ) {
					//we're going to want the vector later and not the point anyway
					closest.addSource(new Point2D.Double(sdx, sdy));
				}
			}
			
			//Add nodes -- calc vector for nodes with sources and add a node
			for(NodeAuxin n : partition) {
				if(n.sources == null)
					continue;	//no auxin sources, so no growing here
				
				//Sum the vectors
				double dx = 0, dy = 0;
				AuxSource src = n.sources;
				while(src != null) {
					dx += src.src.x;
					dy += src.src.y;
					src = src.next;
				}
				
				//Normalize
				double mag = Math.sqrt(dx*dx + dy*dy);
				if( mag != 0 ) {
					dx /= mag;
					dy /= mag;
				}
				
				//Multiply by 2 node radii (parent and new child)
				dx *= nodes.radius * 2;
				dy *= nodes.radius * 2;
				
				//Get new x,y
				final Nodes.Node parent = n.node;
				final Point newPt = new Point((int)(parent.p.x - dx), (int)(parent.p.y - dy));
				
				//And add the new node
				//if( bounds.contains(newPt) && !nodes.overlap(newPt, nodes.radius - 1) )
					nodes.add(parent, newPt);
			}
			
			//Grow
			if( growFactor > 1.0 ) {
				bounds.scale(nodes.getFirst(), growFactor);
			}
			
			//Kill covered auxin (if a node is on top of it, or it is out of bounds)
			for(Iterator<Point> it = auxin.iterator(); it.hasNext(); ) {
				final Point aux = it.next();
				if( !bounds.contains(aux) || nodes.overlap(aux, auxin.radius) )
					it.remove();	//out of the leaf (due to growth), or covered by a node
			}
			
			//Add auxin
			addAuxin(bounds, nodes, auxin, addPts);
		}
	}
	
	
	private void addAuxin(Bounds bounds, Nodes nodes, Auxin auxin, int count) {
		Dimension d = bounds.getSize();
		Point off = bounds.getOffset();
points:
		for(int c = 0; c < count; c++) {
			int tries = 3;
			do {
				Point p = new Point(rand(0, d.width) + off.x, rand(0, d.height) + off.y);
				
				if( bounds.contains(p) && !nodes.overlap(p, auxin.radius) && auxin.addPoint(p) )
					continue points;	//got one!
				
				tries--;
			} while(tries > 0);
		}
	}
	
	private int rand(int min, int max) {
		return ((int)(Math.random() * (max - min))) + min;
	}
	
}
